//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "../../include/ScnLib.h"
#ifdef _WIN64
#pragma comment(lib, "../../lib/C++ Builder/x64/ScnLib.lib")
#else
#pragma comment(lib, "../../lib/C++ Builder/x86/ScnLib.lib")
#endif

#include "DemoDlg.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainWindow *MainWindow;
//---------------------------------------------------------------------------
__fastcall TMainWindow::TMainWindow(TComponent* Owner)
	: TForm(Owner)
{
	m_dibFPS = NULL;
}
//---------------------------------------------------------------------------



void __fastcall TMainWindow::FormCreate(TObject *Sender)
{
	TCHAR	logPath[MAX_PATH] = {};

	// Make the log file path the same as the process exe file path but different extension.
	GetModuleFileName(NULL, logPath, MAX_PATH);
	PathRenameExtension(logPath, _T(".txt"));

	// Create a log file that is helpful for debugging.
	// It can be called before calling ScnLib_Initialize().
	ScnLib_SetLogPathW(logPath, TRUE);

	// Initialize the SDK.
	// It must be called before calling most of the other APIs of the SDK.
	// Usually it's called only once at the start of the program.
	ScnLib_InitializeW(NULL);

	// Make the screen capture region frame visible. It's invisible by default.
	// If you don't like the style of the SDK built-in screen capture region frame, you may implement your own.
	ScnLib_ShowCaptureRegionFrame(TRUE);

	// We prefer 1080p webcam resolution. It's 320x240 by default.
	// If your webcam doesn't support the resolution you set, the SDK will choose the closest resolution automatically.
	ScnLib_SetWebcamResolution(1920, 1080);

	// Default mode: Capture Full Screen
	full_screen->Checked = true;

	// Initialize the game FPS DIB resource.
	Init_Game_FPS_Overlay();

	// Setup a timer to update the game FPS overlay for game capture mode
	timer_FPS->Enabled = true;

	Update_UI();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::FormDestroy(TObject *Sender)
{
	// Release the game FPS DIB resource.
	Free_Game_FPS_Overlay();

	// Uninitialize the SDK.
	// It must be called before exiting the process or there might be resource leak.
	// Usually it's called only once at the end of the program.
	ScnLib_Uninitialize();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::timer_RECTimer(TObject *Sender)
{
	// Since the SDK doesn't have any callback mechanism,
	// you need to check the recording status periodically in a timer.
	// If it's recording then update the recording time info.
	if (ScnLib_IsRecording())
	{
		TCHAR	szRecTime[11];

		// Get the current recording time string in the format of 'HH:MM:SS'.
		ScnLib_GetRecTimeW(szRecTime);

		rec_time->Caption = szRecTime;
	}
	// If it's not recording then stop recording on failure.
	// The recording may stop automatically if a fatal error occurs.
	// In this case you still need to do some cleanup and UI updates.
	else
	{
		Stop_Recording(FALSE);

		Update_UI();
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::timer_FPSTimer(TObject *Sender)
{
	// Is currently game capture mode and a Direct3D/OpenGL game window detected?
	if (ScnLib_GetGameWnd())
	{
		// Update the game FPS overlay.
		Update_Game_FPS_Overlay();
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::start_stopClick(TObject *Sender)
{
	if (!ScnLib_IsRecording())
	{
		// Start recording if no recording is in progress.
		Start_Recording();
	}
	else
	{
		// Stop recording if a recording is in progress.
		Stop_Recording(TRUE);
	}

	Update_UI();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::pause_resumeClick(TObject *Sender)
{
	if (!ScnLib_IsPaused())
	{
		// Pause recording if the recording is not paused.
		ScnLib_PauseRecording();
	}
	else
	{
		// Resume recording if the recording is paused.
		ScnLib_ResumeRecording();
	}

	Update_UI();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::more_settingsClick(TObject *Sender)
{
	// Popup the SDK built-in settings dialog to let user configure more settings.
	// If you don't like the style of the SDK built-in settings dialog, you may implement your own.
	ScnLib_ConfigureSettings(Handle);

	Update_UI();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::change_video_pathClick(TObject *Sender)
{
	TCHAR videoPath[MAX_PATH] = {};
	OPENFILENAME ofn = {};

	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = Handle;
	// Supported video file formats are MP4, FLV and AVI.
	ofn.lpstrFilter = _T("MP4 videos (*.mp4)\0*.mp4\0FLV videos (*.flv)\0*.flv\0AVI videos (*.avi)\0*.avi\0");
	ofn.lpstrDefExt = _T("mp4");
	ofn.lpstrFile = videoPath;
	ofn.nMaxFile = MAX_PATH;
	ofn.Flags = OFN_OVERWRITEPROMPT;
	ofn.lpstrTitle = _T("Set Output Video File Path");

	// Popup a save file dialog to let user change the output video file path.
	if (GetSaveFileName(&ofn))
	{
		// Set the output video file path to be created.
		ScnLib_SetVideoPathW(ofn.lpstrFile);

		Update_UI();
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::browse_video_pathClick(TObject *Sender)
{
	TCHAR videoPath[MAX_PATH] = {};

	// Get the output video file path to be created.
	ScnLib_GetVideoPathW(videoPath, FALSE);

	String filePath = videoPath;

	// Remove the invalid file path chars that are used by SDK-defined variables: <num>, <date> and <time>
	filePath = StringReplace(filePath, _T("<"), _T(""), TReplaceFlags()<<rfReplaceAll);
	filePath = StringReplace(filePath, _T(">"), _T(""), TReplaceFlags()<<rfReplaceAll);

	// Get the folder where your recording videos are saved.
	StrCpy(videoPath, filePath.c_str());
	PathRemoveFileSpec(videoPath);

	if (PathIsDirectory(videoPath))
	{
		// Browse the video folder in the Windows File Explorer.
		ShellExecute(Handle, NULL, _T("explorer.exe"), videoPath, NULL, SW_SHOWNORMAL);
	}
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::full_screenClick(TObject *Sender)
{
	// Don't bind any capture window.
	ScnLib_SetCaptureWnd(NULL, FALSE);
	// Set all-zero coordinates to let SDK detect and use the full screen coordinates.
	ScnLib_SetCaptureRegion(0, 0, 0, 0);
	// Make sure the game capture mode is disabled.
	ScnLib_EnableGameCaptureMode(FALSE);
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::a_region_windowClick(TObject *Sender)
{
	long l = 0, t = 0, r = 0, b = 0;
	HWND hwnd = NULL;

	// Turn mouse cursor into a crosshair and let user select a region/window on screen.
	// To select a region:
	//   1) Move the mouse cursor to the top-left corner of the region you want to capture.
	//   2) Press and hold the left mouse button, and then move the mouse cursor to the bottom-right corner of the region you want to capture.
	//   3) Release the left mouse button, done. Or, you can click the right mouse button to cancel in the middle of the process.
	// To select a window:
	//   1) Move the mouse cursor over the window you want to capture and then the window will be highlighted.
	//   2) Click the left mouse button to select the pointing window.
	// To cancel selection, click the right mouse button.
	// If a region is selected, you will get the region coordinates and a zero window handle.
	// If a window is selected, you will get the window coordinates and a non-zero window handle.
	if (ScnLib_SelectCaptureRegionW(&l, &t, &r, &b, &hwnd, NULL))
	{
		// Bind the capture window if hwnd is non-zero.
		// Or unbind the capture window if hwnd is zero.
		ScnLib_SetCaptureWnd(hwnd, TRUE);
		// Set the capture region coordinates.
		ScnLib_SetCaptureRegion(l, t, r, b);
	}

	// Make sure the game capture mode is disabled.
	ScnLib_EnableGameCaptureMode(FALSE);
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::pc_game_screenClick(TObject *Sender)
{
	// Don't bind any capture window. (You can bind a specific game window if you don't want SDK to detect foreground game window automatically)
	ScnLib_SetCaptureWnd(NULL, FALSE);
	// Set all-zero coordinates to let SDK detect and use the full screen coordinates if no game screen is detected.
	ScnLib_SetCaptureRegion(0, 0, 0, 0);
	// Enable the game capture mode.
	ScnLib_EnableGameCaptureMode(TRUE);
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::playback_audioClick(TObject *Sender)
{
	// Enable/Disable capture from the playback audio source (speakers / headphone).
	ScnLib_RecordAudioSource(TRUE, playback_audio->Checked);
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::microphone_audioClick(TObject *Sender)
{
	// Enable/Disable capture from the recording audio source (microphone / line-in).
	ScnLib_RecordAudioSource(FALSE, microphone_audio->Checked);
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::webcam_previewClick(TObject *Sender)
{
	// Open/Close the webcam preview window.
	ScnLib_PreviewWebcam(webcam_preview->Checked, NULL, TRUE, 0);
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::webcam_overlayClick(TObject *Sender)
{
	if (webcam_overlay->Checked)
	{
		// Enable webcam capture by selecting the first webcam device.
		ScnLib_SelectWebcamDevice(0);
		// Don't record webcam only. Put the webcam overlay on the screen capture video.
		ScnLib_RecordWebcamOnly(FALSE);
	}
	else if (!full_webcam_video->Checked)
	{
		// Close the webcam preview window.
		ScnLib_PreviewWebcam(FALSE, NULL, TRUE, 0);
		// Disable webcam capture by selecting a negative index.
		ScnLib_SelectWebcamDevice(-1);
	}

	Update_UI();
}
//---------------------------------------------------------------------------

void __fastcall TMainWindow::full_webcam_videoClick(TObject *Sender)
{
	if (full_webcam_video->Checked)
	{
		// Enable webcam capture by selecting the first webcam device.
		ScnLib_SelectWebcamDevice(0);
		// Record webcam only. Discard screen capture. Make a full webcam video.
		ScnLib_RecordWebcamOnly(TRUE);
	}
	else if (!webcam_overlay->Checked)
	{
		// Close the webcam preview window.
		ScnLib_PreviewWebcam(FALSE, NULL, TRUE, 0);
		// Disable webcam capture by selecting a negative index.
		ScnLib_SelectWebcamDevice(-1);
	}

	Update_UI();
}
//---------------------------------------------------------------------------

void TMainWindow::Init_Game_FPS_Overlay(void)
{
	// FPS: Frames Per Second
	// DIB: Device-Independent Bitmap
	// Create the game FPS DIB.
	m_dibFPS = new TBitmap;

	if (m_dibFPS)
	{
		m_dibFPS->HandleType = bmDIB;
		m_dibFPS->PixelFormat = pf24bit;
		m_dibFPS->Width = 170;
		m_dibFPS->Height = -70; // a top-down bitmap
		m_dibFPS->Canvas->Font->Name = _T("Impact");
	}
}
//---------------------------------------------------------------------------

void TMainWindow::Free_Game_FPS_Overlay(void)
{
	if (m_dibFPS)
	{
		delete m_dibFPS;
		m_dibFPS = NULL;
	}
}
//---------------------------------------------------------------------------

void TMainWindow::Update_Game_FPS_Overlay(void)
{
	// Check the game FPS DIB object pointer.
	if (!m_dibFPS) return;

	// The game FPS DIB dimension.
	int w = m_dibFPS->Width;
	int h = m_dibFPS->Height;
	TRect rc(0, 0, w, h);
	String strFPS;

	// Get the game FPS number.
	strFPS.sprintf(_T("%d fps"), ScnLib_GetGameFrameRate());

	TCHAR szRecTime[11];

	// Get the current recording time string in the format of 'HH:MM:SS'.
	ScnLib_GetRecTimeW(szRecTime);

	// Clear the overlay background.
	m_dibFPS->Canvas->Brush->Style = bsSolid;
	m_dibFPS->Canvas->Brush->Color = TColor(RGB(255, 255, 255));
	m_dibFPS->Canvas->FillRect(rc);

	// Shrink the drawing area.
	InflateRect(&rc, -3, -3);

	// Display a camera icon on the left side.
	DrawIconEx(m_dibFPS->Canvas->Handle, rc.left, rc.top, Icon->Handle, rc.Height(), rc.Height(), 0, NULL, DI_NORMAL);

	// Draw the game FPS number.
	m_dibFPS->Canvas->Font->Height = -30;
	m_dibFPS->Canvas->Font->Color = TColor(RGB(128, 128, 128));
	DrawText(m_dibFPS->Canvas->Handle, strFPS.c_str(), -1, &rc, DT_RIGHT | DT_TOP | DT_SINGLELINE);

	// Draw the REC time.
	m_dibFPS->Canvas->Font->Height = -25;
	m_dibFPS->Canvas->Font->Color = TColor(ScnLib_IsRecording() ? RGB(255, 0, 0) : RGB(0, 200, 0));
	DrawText(m_dibFPS->Canvas->Handle, szRecTime, -1, &rc, DT_RIGHT | DT_BOTTOM | DT_SINGLELINE);

	// Show the game FPS overlay on the top-right corner of the game screen.
	ScnLib_SetInGameOverlayPosition(SCNLIB_POSITION_TOP_RIGHT, 5, 5);
	ScnLib_ShowInGameOverlay(m_dibFPS->ScanLine[h - 1], w, h, 24);
}
//---------------------------------------------------------------------------

void TMainWindow::Update_UI(void)
{
	// Update the radio boxes in the Screen Capture group.
	full_screen->Enabled = !ScnLib_IsRecording();
	a_region_window->Enabled = !ScnLib_IsRecording();
	pc_game_screen->Enabled = !ScnLib_IsRecording();

	// Update the check boxes in the Audio Capture group.
	playback_audio->Checked = ScnLib_IsRecordAudioSource(TRUE); // TRUE - the playback audio source (speakers / headphone)
	microphone_audio->Checked = ScnLib_IsRecordAudioSource(FALSE); // FALSE - the recording audio source (microphone / line-in)

	// Update the check boxes in the Webcam Capture group
	// The webcam capture is enabled only when a webcam device is selected.
	// The selected webcam device index is a zero-based number. The first webcam device index is 0.
	if (ScnLib_GetSelectedWebcamDevice() >= 0)
	{
		webcam_preview->Enabled = true;

		// If the webcam is being previewed you can get a non-zero preview window handle.
		if (ScnLib_GetWebcamPreviewWnd() != NULL)
		{
			webcam_preview->Checked = true;
		}
		// Otherwise the webcam is not being previewed.
		else
		{
			webcam_preview->Checked = false;
		}

		// If it's set to record webcam only, screen capture will be discarded and you will get a full webcam video.
		if (ScnLib_IsRecordWebcamOnly())
		{
			webcam_overlay->Checked = false;
			full_webcam_video->Checked = true;
		}
		// Otherwise you will get a screen recording video with a webcam overlay on it.
		else
		{
			webcam_overlay->Checked = true;
			full_webcam_video->Checked = false;
		}
	}
	// A negative index means no webcam device is selected.
	else
	{
		webcam_preview->Enabled = false;
		webcam_preview->Checked = false;
		webcam_overlay->Checked = false;
		full_webcam_video->Checked = false;
	}

	// Update the elements in the Output Video group.
	TCHAR videoPath[MAX_PATH] = {};

	// Get the output video file path to be created.
	ScnLib_GetVideoPathW(videoPath, FALSE);

	video_path->Text = videoPath;
	video_path->Enabled = !ScnLib_IsRecording();
	change_video_path->Enabled = !ScnLib_IsRecording();

	// Update the recording control buttons at the bottom.
	if (ScnLib_IsRecording())
	{
		start_stop->Caption = _T("Stop");
	}
	else
	{
		start_stop->Caption = _T("Start");
	}

	if (ScnLib_IsPaused())
	{
		pause_resume->Caption = _T("Resume");
	}
	else
	{
		pause_resume->Caption = _T("Pause");
	}

	pause_resume->Enabled = ScnLib_IsRecording();
}
//---------------------------------------------------------------------------

void TMainWindow::Start_Recording(void)
{
	// If no foreground Direct3D/OpenGL game window is detected, prompt user what to do.
	if (ScnLib_IsGameCaptureModeEnabled() && !ScnLib_GetGameWnd())
	{
		MessageBox(Handle, _T("\
No foreground Direct3D/OpenGL game window is detected!\n\n\
Please open a Direct3D/OpenGL game and place its window in the foreground, \
or the SDK will automatically fallback to standard screen capture mode."),
			Caption.c_str(), MB_ICONINFORMATION | MB_OK);
	}

	// Set the output video file path to be created.
	// The file path can include SDK-defined variables: <num>, <date> and <time>
	ScnLib_SetVideoPathW(video_path->Text.c_str());

	// Start recording now.
	if (ScnLib_StartRecording())
	{
		// Start the timer to check the recording status and update recording time.
		timer_REC->Enabled = true;
	}
	else
	{
		// Do some cleanup if recording failed to start.
		Stop_Recording(FALSE);
	}
}
//---------------------------------------------------------------------------

void TMainWindow::Stop_Recording(BOOL bSuccessful)
{
	// Stop the timer
	timer_REC->Enabled = false;

	// Stop the recording. It's OK to call it even if no recording is in progress.
	ScnLib_StopRecording();

	TCHAR filePath[MAX_PATH] = {};

	if (bSuccessful)
	{
		// Get the saved video file path if the recording is done successfully.
		ScnLib_GetVideoPathW(filePath, TRUE);
	}
	else
	{
		// Get the saved log file path if the recording is failed.
		ScnLib_GetLogPathW(filePath);
	}

	// Play the video file or show the log file.
	if (PathFileExists(filePath))
	{
		ShellExecute(Handle, _T("open"), filePath, NULL, NULL, SW_SHOWNORMAL);
	}
}
//---------------------------------------------------------------------------

